clc;
close all;
%% Load 10 identical simulated Cohen coarse crackles here 
load SC1_Cohen
load SC2_Cohen
load SC3_Cohen
load SC4_Cohen
load SC5_Cohen
load SC6_Cohen
load SC7_Cohen
load SC8_Cohen
load SC9_Cohen
load SC10_Cohen
fs              = 44100;                                                          %% Sampling frequency
Signal_length   = 32768;                                                          %% Signal length
%% Make the length equal
SC1_Cohen       = [zeros(1,1000),SC1_Cohen,zeros(1,Signal_length-(1000+length(SC1_Cohen)))];
SC2_Cohen       = [zeros(1,3000),SC2_Cohen,zeros(1,Signal_length-(3000+length(SC2_Cohen)))];
SC3_Cohen       = [zeros(1,7000),SC3_Cohen,zeros(1,Signal_length-(7000+length(SC3_Cohen)))];
SC4_Cohen       = [zeros(1,12000),SC4_Cohen,zeros(1,Signal_length-(12000+length(SC4_Cohen)))];
SC5_Cohen       = [zeros(1,14000),SC5_Cohen,zeros(1,Signal_length-(14000+length(SC5_Cohen)))];
SC6_Cohen       = [zeros(1,17000),SC6_Cohen,zeros(1,Signal_length-(17000+length(SC6_Cohen)))];
SC7_Cohen       = [zeros(1,20000),SC7_Cohen,zeros(1,Signal_length-(20000+length(SC7_Cohen)))];
SC8_Cohen       = [zeros(1,23000),SC8_Cohen,zeros(1,Signal_length-(23000+length(SC8_Cohen)))];
SC9_Cohen       = [zeros(1,27500),SC9_Cohen,zeros(1,Signal_length-(27500+length(SC9_Cohen)))];
SC10_Cohen      = [zeros(1,30000),SC10_Cohen,zeros(1,Signal_length-(30000+length(SC10_Cohen)))];
Ten_identical_simulated_Cohen_coarse_crackles       = SC1_Cohen+SC2_Cohen+SC3_Cohen+SC4_Cohen+SC5_Cohen+SC6_Cohen+SC7_Cohen+SC8_Cohen+SC9_Cohen+SC10_Cohen;
Ten_identical_simulated_Cohen_coarse_crackles       = Ten_identical_simulated_Cohen_coarse_crackles(1:end);
%% Plot
figure
plot(Ten_identical_simulated_Cohen_coarse_crackles,'k');
xlabel('Number of samples','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
%%
text(1150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(250,.85,'SC1-C','fontsize',8,'FontWeight','bold')
text(3150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(3150,.85,'SC2-C','fontsize',8,'FontWeight','bold')
text(7150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(7000,.85,'SC3-C','fontsize',8,'FontWeight','bold')
text(12150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(11150,.85,'SC4-C','fontsize',8,'FontWeight','bold')
text(14150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(14150,.85,'SC5-C','fontsize',8,'FontWeight','bold')
text(17150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(17150,.85,'SC6-C','fontsize',8,'FontWeight','bold')
text(20150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(20150,.85,'SC7-C','fontsize',8,'FontWeight','bold')
text(23150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(23150,.85,'SC8-C','fontsize',8,'FontWeight','bold')
text(27650,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(26500,.85,'SC9-C','fontsize',8,'FontWeight','bold')
text(30150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(29800,.85,'SC10-C','fontsize',8,'FontWeight','bold')
%%
set(gcf, 'Position',  [100, 300, 800, 300])
title('10 identical simulated Cohen coarse crackles','FontSize',12,'FontName','Times New Roman','fontweight','bold');
xlim([0 Signal_length]);
ylim([-1 1]);
